/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.history;

import emulator.history.BitStateChange;
import emulator.history.BitStateHistory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitStateHistoryTest {
    static final int HISTORY_SIZE = 10;
    private BitStateHistory history;
    private BitStateChange change1 = new BitStateChange(1L, true);
    private BitStateChange change17 = new BitStateChange(17L, false);
    private BitStateChange change23 = new BitStateChange(23L, true);
    private BitStateChange change42 = new BitStateChange(42L, false);
    private BitStateChange change99 = new BitStateChange(99L, true);

    @Before
    public void setUp() throws Exception {
        this.history = new BitStateHistory(10);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddDecreasingTicks() {
        this.history.add(new BitStateChange(2L, true));
        this.history.add(new BitStateChange(1L, false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddUnchangedState() {
        this.history.add(new BitStateChange(1L, true));
        this.history.add(new BitStateChange(2L, true));
    }

    @Test
    public void testGetGreaterOrEqualEmpty() {
        Assert.assertEquals((long)-1L, (long)this.history.getGreaterOrEqualIndex(0L));
    }

    @Test
    public void testGetLessOrEqualEmpty() {
        Assert.assertEquals((long)-1L, (long)this.history.getLessOrEqualIndex(Long.MAX_VALUE));
    }

    @Test
    public void testGetGreaterOrEqualSingleEntry() {
        this.history.add(this.change42);
        Assert.assertEquals((long)0L, (long)this.history.getGreaterOrEqualIndex(41L));
        Assert.assertEquals((long)0L, (long)this.history.getGreaterOrEqualIndex(42L));
        Assert.assertEquals((long)-1L, (long)this.history.getGreaterOrEqualIndex(43L));
    }

    @Test
    public void testGetLessOrEqualSingleEntry() {
        this.history.add(this.change42);
        Assert.assertEquals((long)-1L, (long)this.history.getLessOrEqualIndex(41L));
        Assert.assertEquals((long)0L, (long)this.history.getLessOrEqualIndex(42L));
        Assert.assertEquals((long)0L, (long)this.history.getLessOrEqualIndex(43L));
    }

    @Test
    public void testGetGreaterOrEqualSequence() {
        this.initHistory();
        Assert.assertEquals((long)0L, (long)this.history.getGreaterOrEqualIndex(0L));
        Assert.assertEquals((long)0L, (long)this.history.getGreaterOrEqualIndex(1L));
        Assert.assertEquals((long)1L, (long)this.history.getGreaterOrEqualIndex(7L));
        Assert.assertEquals((long)2L, (long)this.history.getGreaterOrEqualIndex(23L));
        Assert.assertEquals((long)3L, (long)this.history.getGreaterOrEqualIndex(39L));
        Assert.assertEquals((long)4L, (long)this.history.getGreaterOrEqualIndex(99L));
        Assert.assertEquals((long)-1L, (long)this.history.getGreaterOrEqualIndex(100L));
    }

    @Test
    public void testGetLessOrEqualSequence() {
        this.initHistory();
        Assert.assertEquals((long)-1L, (long)this.history.getLessOrEqualIndex(0L));
        Assert.assertEquals((long)0L, (long)this.history.getLessOrEqualIndex(1L));
        Assert.assertEquals((long)1L, (long)this.history.getLessOrEqualIndex(17L));
        Assert.assertEquals((long)2L, (long)this.history.getLessOrEqualIndex(23L));
        Assert.assertEquals((long)3L, (long)this.history.getLessOrEqualIndex(43L));
        Assert.assertEquals((long)4L, (long)this.history.getLessOrEqualIndex(99L));
        Assert.assertEquals((long)4L, (long)this.history.getLessOrEqualIndex(100L));
    }

    @Test
    public void testGetRangeEmptyHistory() {
        Assert.assertEquals((long)0L, (long)this.history.getRange(0L, Long.MAX_VALUE).length);
    }

    @Test
    public void testGetRangeEmpty() {
        this.initHistory();
        Assert.assertEquals((long)0L, (long)this.history.getRange(0L, 0L).length);
        Assert.assertEquals((long)0L, (long)this.history.getRange(18L, 22L).length);
        Assert.assertEquals((long)0L, (long)this.history.getRange(100L, Long.MAX_VALUE).length);
    }

    @Test
    public void testGetRangeFull() {
        this.initHistory();
        BitStateChange[] fullRange = this.history.getRange(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)5L, (long)fullRange.length);
        Assert.assertEquals((Object)this.change1, (Object)fullRange[0]);
        Assert.assertEquals((Object)this.change17, (Object)fullRange[1]);
        Assert.assertEquals((Object)this.change23, (Object)fullRange[2]);
        Assert.assertEquals((Object)this.change42, (Object)fullRange[3]);
        Assert.assertEquals((Object)this.change99, (Object)fullRange[4]);
    }

    @Test
    public void testGetRangePart() {
        this.initHistory();
        BitStateChange[] partRange = this.history.getRange(2L, 50L);
        Assert.assertEquals((long)3L, (long)partRange.length);
        Assert.assertEquals((Object)this.change17, (Object)partRange[0]);
        Assert.assertEquals((Object)this.change23, (Object)partRange[1]);
        Assert.assertEquals((Object)this.change42, (Object)partRange[2]);
    }

    @Test
    public void testHistorySizeOverflow() {
        BitStateChange[] expectedHistory = new BitStateChange[10];
        boolean state = false;
        long tick = 7L;
        int i = 0;
        while (i < 5) {
            this.history.add(new BitStateChange(tick, state));
            state = !state;
            tick += 3L;
            ++i;
        }
        i = 0;
        while (i < 10) {
            expectedHistory[i] = new BitStateChange(tick, state);
            this.history.add(expectedHistory[i]);
            state = !state;
            tick += 3L;
            ++i;
        }
        BitStateChange[] actualHistory = this.history.getRange(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)expectedHistory.length, (long)actualHistory.length);
        int i2 = 0;
        while (i2 < expectedHistory.length) {
            Assert.assertEquals((Object)expectedHistory[i2], (Object)actualHistory[i2]);
            ++i2;
        }
    }

    private void initHistory() {
        this.history.add(this.change1);
        this.history.add(this.change17);
        this.history.add(this.change23);
        this.history.add(this.change42);
        this.history.add(this.change99);
    }
}

